-- T-SQL Window Function Deep Dive
-- Framing
SET STATISTICS IO ON;
GO
USE AdventureWorks2014;
GO

--Framing
--Default frame
SELECT CustomerID, SalesOrderID, OrderDate, TotalDue, 
	SUM(TotalDue) OVER(PARTITION BY CustomerID ORDER BY SalesOrderID) 
	AS RunningTotal
FROM Sales.SalesOrderHeader;

--RANGE
SELECT CustomerID, SalesOrderID, OrderDate, TotalDue, 
	SUM(TotalDue) OVER(PARTITION BY CustomerID ORDER BY SalesOrderID
		RANGE BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW) AS RunningTotal
FROM Sales.SalesOrderHeader;

--Change to ROWS
SELECT CustomerID, SalesOrderID, OrderDate, TotalDue, 
	SUM(TotalDue) OVER(PARTITION BY CustomerID ORDER BY SalesOrderID
		ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW) AS RunningTotal
FROM Sales.SalesOrderHeader;

--Analytic function
SELECT CustomerID, SalesOrderID, OrderDate, TotalDue,
	FIRST_VALUE(SalesOrderID) 
	OVER(PARTITION BY CustomerID ORDER BY SalesOrderID) AS PrevOrder
FROM Sales.SalesOrderHeader;

SELECT CustomerID, SalesOrderID, OrderDate, TotalDue,
	FIRST_VALUE(SalesOrderID) 
	OVER(PARTITION BY CustomerID ORDER BY SalesOrderID
	ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW) AS PrevOrder
FROM Sales.SalesOrderHeader;

--When ROWS gives you a worktable on disk
--Large number of rows in partition
SELECT transactionid, first_value(transactiondate) 
	OVER(PARTITION BY productid ORDER BY transactiondate
		ROWS UNBOUNDED PRECEDING) AS FirstTransactionDate
FROM bigTransactionHistory
WHERE transactiondate < '2005-1-10';

--Expression for LAG offset
DECLARE @Offset INT = 10;

SELECT CustomerID, SalesOrderID, LAG(SalesOrderID, @Offset) 
	OVER(PARTITION BY CustomerID ORDER BY SalesOrderID)
FROM Sales.SalesOrderHeader;



